<p align="center"><a href="https://www.uvdesk.com/en/" target="_blank">
    <img src="https://s3-ap-southeast-1.amazonaws.com/cdn.uvdesk.com/uvdesk/bundles/webkuldefault/images/uvdesk-wide.svg">
</a></p>

<p align="center">
    <a href="https://packagist.org/packages/uvdesk/community-skeleton"><img src="https://poser.pugx.org/uvdesk/community-skeleton/v/stable.svg" alt="Latest Stable Version"></a>
    <a href="https://packagist.org/packages/uvdesk/community-skeleton"><img src="https://poser.pugx.org/uvdesk/community-skeleton/d/total.svg" alt="Total Downloads"></a>
    <a href="#backers"><img src="https://opencollective.com/uvdesk/backers/badge.svg" alt="Backers on Open Collective"></a>
    <a href="#sponsors"><img src="https://opencollective.com/uvdesk/sponsors/badge.svg" alt="Sponsors on Open Collective"></a>
    <a href="https://gitter.im/uvdesk/community"><img src="https://badges.gitter.im/uvdesk/community-skeleton.svg" alt="connect on gitter"></a>
    <a href="https://forums.uvdesk.com"><img src="https://img.shields.io/badge/Ask%20me-anything-1abc9c.svg" alt="discuss on uvdesk forum"></a>
    <a href="https://github.com/collections/made-in-india"><img src="https://badges.frapsoft.com/os/v3/open-source.png?v=103" alt="Checkout us on open source projects from India"></a>
</p>

<p align="center">
    <a href="https://twitter.com/intent/follow?screen_name=uvdesk"><img src="https://img.shields.io/twitter/follow/uvdesk?style=social"></a>
    <a href="https://www.youtube.com/channel/UCKKt4IOC7ynLwhJMP35uFeQ"><img src="https://img.shields.io/youtube/channel/subscribers/UCKKt4IOC7ynLwhJMP35uFeQ?style=social"></a>
</p>

<p align="center">
    ➡️ <a href="https://www.uvdesk.com/en/opensource/">Website</a> | <a href="https://docs.uvdesk.com/">Documentation</a> | <a href="https://www.uvdesk.com/en/blog/open-source-helpdesk-installation-on-ubuntu-uvdesk/">Installation Guide</a> | <a href="https://forums.uvdesk.com/">Forums</a> | <a href="https://www.facebook.com/uvdesk/">Community</a> ⬅️
</p>

<p align="center" style="display: inline;">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/ar.svg" alt="Arabic" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/de.svg" alt="German" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/us.svg" alt="English" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/es.svg" alt="Spanish" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/fr.svg" alt="French" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/it.svg" alt="Italian" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/dk.svg" alt="Danish" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/pl.svg" alt="Polish" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/tr.svg" alt="Turkish" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/cn.svg" alt="Chinese" width="24" height="24">
    <img class="flag-img" src="https://flagicons.lipis.dev/flags/4x3/br.svg" alt="Brazil" width="24" height="24">
</p>

[Uvdesk community helpdesk][1] project skeleton packaged along with the bare essential utilities and tools to build and customize your own helpdesk solutions.

Visit our official demo website to [see it in action!][15]

Check out UVdesk on **Symfony Official Website** – [Symfony][24]

Getting Started
-----------------

* [About](#about)
* [Features](#features)
* [Documentation](#documentation)
* [Modules](#modules)
* [Requirements](#requirements)
* [Installation](#installation)
* [Docker Runtime](#docker-runtime)
* [Docker Persistent Container](#docker-persistent-container)
* [Vagrant Virtual Environment](#vagrant-virtual-environment)
* [License](#license)
* [Security Vulnerabilities](#security-vulnerabilities)
* [Feedback](#feedback)
* [Contributions](#contributions)

About
-----------------

Build on top of [symfony](https://symfony.com/) and [backbone.js](https://backbonejs.org/), UVdesk Community is an open-source, service-oriented, and event-driven helpdesk system designed for easy customization and seamless client support. Its extensible architecture allows organizations to deliver efficient, tailored customer service with minimal effort.

The standard distribution includes a comprehensive set of helpdesk packages to support a wide range of use cases and operational needs.

  * [**Core Framework**][2] - At the heart of the helpdesk system, the core framework consists of all the necessary apis required by your project and dependent packages to keep things running smoothly

  * [**Extension Framework**][3] - Introduces support for third-party package integration and development to easily build and extend the functionalities of your helpdesk system as per your requirements

  * [**Automation Bundle**][4] - Adds support for workflows and prepared responses to automate any specific operations within your helpdesk system

  * [**Mailbox Component**][11] - Convert and get all your emails to support tickets on UVDesk and manage customer query easily.

  * [**Support Center Bundle**][5] - Integrates the easily customizable support center portal to enable users to easily interact with the support staff through your helpdesk system

Reach out to us at our official [gitter chat][20] or by joining [forum][21] for any queries, concerns and feature request discussions.

The development of the uvdesk community edition is led by the [uvdesk][10] team and backed by [Webkul][9]. Visit our [website][1] to learn more about the UVDesk Helpdesk System.

Features
----------------

* [Translation Support (Multilingual)][32]
* Unlimited agents, groups, teams, customers, tickets, and more.
* Agent Privileges
* No limit on the number of mailbox/email integrations.
* Saved Replies – Quickly respond to frequent questions.
* Filter tickets by status, ID, agent, customer, and more.
* Block Spam
* [Agent Activity][29]
* [Marketing Announcement][30]
* [Marketing Modules][35]
* [Kudos][31]
* [Microsoft Apps][36]
* reCAPTCHA option.
* Standard automated workflows.
* Notes for agents.
* Custom branding.
* Change logo & favicon.
* Broadcasting message.
* Ticket Forwarding.
* Prepared Response.
* Email Notification.
* Effective search.
* User Friendly Web Installer.
* Supports multiple attachments.
* A powerful knowledge base and FAQ system—organize content by articles, categories, and folders.
* Ticket types, Multiple Tags.
* Email Templates.
* [API Bundle][16] and [Documentation][25]
* Edit/Delete/Pinned ticket and thread.
* Easily add collaborators and unlock even more capabilities.
* [Explore Apps][26]

Documentation
--------------

Visit [docs.uvdesk.com](https://docs.uvdesk.com/) to read our official documentation and learn more about the uvdesk community project.

We use Jekyll to develop and maintain our documentations. Consider contributing by submitting a pull request to our project's [jeykll repository](https://github.com/uvdesk/uvdesk.github.io).

Requirements
--------------

* **OS**: Ubuntu 16.04 LTS or higher / Windows 7 or Higher (WAMP / XAMPP).
* **SERVER**: Apache 2 or NGINX.
* **RAM**: 4GB or higher.
* **PHP**: 8.1
* **Processor**: Clock Cycle 1 Ghz or higher.
* **For MySQL users**: 5.7.23 or higher.
* **Composer**: 2 or higher.
* **PHP IMAP** **&** **PHP Mailparse** for [Ubuntu][7], [Windows][23], [Centos][28], [Mac][27].

Installation
--------------

The installation process is broken down into two distinct steps:

* Setup
* Configuration

### Setting up your helpdesk project

In this step, you'll download the Helpdesk project skeleton and install its dependencies.

You can either use Composer to download and install everything automatically, or download a pre-packaged archive that includes all dependencies. We recommend using Composer whenever possible for easier updates and better dependency management. However, if you're on a system with limited resources (e.g., shared hosting), the archive download may be more reliable.

Regardless of the method you choose, the configuration process for Helpdesk remains the same.

#### Composer

You can use composer to setup your project by simply running the following command from your terminal:

```bash
$ composer create-project uvdesk/community-skeleton helpdesk-project
```

#### Direct Download

Alternatively, you can also [download the zip archive](https://cdn.uvdesk.com/uvdesk/downloads/opensource/uvdesk-community-current-stable.zip) of the latest stable release and extract its content by running the following commands from your terminal:

```bash
$ wget "https://cdn.uvdesk.com/uvdesk/downloads/opensource/uvdesk-community-current-stable.zip" -P /var/www/
$ unzip -q /var/www/uvdesk-community-current-stable.zip -d /var/www/ \
```

### Configuring your helpdesk project

After you've downloaded and installed all the project dependencies, you can configure your helpdesk installation using either of the following ways:

#### Using Terminal

```bash
$ php bin/console uvdesk:configure-helpdesk
```

#### Using Web Installer Wizard

##### Extract the contents of zip and execute the project in your browser in case of project zip download:

~~~
http(s)://localhost/community-skeleton/public
~~~

##### In case of created project using command, execute the project in your browser:

~~~
http(s)://localhost/helpdesk-project/public
~~~

or

~~~
http(s)://example.com/public
~~~

After opening your project in the web browser, you will be greeted by the web installer which will guide you in configuring your project.

##### Run project on localhost (dev mode)
```bash
php bin/console server:run
```

**How to clear cache:**

```bash
php bin/console c:c
```

#### ☁️ Deploy UVdesk on the Cloud with Amazon AMI

Easily launch UVdesk on the cloud using our pre-configured Amazon Machine Image (AMI), available directly from the AWS Marketplace:

👉 [**Launch UVdesk on AWS**](https://aws.amazon.com/marketplace/pp/prodview-c4pibdsnipim4)

This AMI offers a quick and hassle-free way to set up UVdesk on a secure, scalable AWS environment. Perfect for both production deployments and testing purposes, with no need for manual configuration.

**How to log in as admin/agent:**

*Below url is the default url for admin/agent login if you have not made any changes for /member prefix.*

> *http(s)://example.com/en/member/login* 

**How to log in as customer:**

*Below url is the default url for customer login if you have not made any changes for /customer prefix.*

> *http(s)://example.com/en/customer/login*

Docker Runtime
--------------

[Dockerize your helpdesk project][22]

Docker Persistent Container
--------------

[Get started with Uvdesk now by using docker persistent container][34]

Vagrant Virtual Environment
--------------

[Get started with uvdesk now by using vagrant to setup virtual environment][33]

Modules
--------------

[Available Modules/Apps](https://store.webkul.com/UVdesk/UVdesk-Open-Source.html)

Need something else ? email us at support@uvdesk.com

License
--------------

All libraries and bundles included in the UVDesk Community Edition are released under the [OSL-3.0 license][12] license.

Security Vulnerabilities
--------------

Please don't disclose any security vulnerabilities publicly. If you find any security vulnerability in our platform then please write us at [support@uvdesk.com](mailto:support@uvdesk.com).

Feedback
---------
#### Feedback (Support Community project by raising feedback)

* [Trustpilot][17]
* [Capterra][18]
* [Software suggest][19]

Contributions
--------------
This project is hosted on [Open Collective][13] and exists thanks to our contributors:

<a href="https://github.com/uvdesk/community-skeleton/graphs/contributors"><img src="https://opencollective.com/uvdesk/contributors.svg?width=890&button=false"/></a>

#### Backers

Thank you to all our backers! 🙏

<a href="https://opencollective.com/uvdesk#contributors" target="_blank"><img src="https://opencollective.com/uvdesk/backers.svg?width=890"></a>

#### Sponsors

Support this project by becoming a sponsor. Your logo will show up here with a link to your website.

<a href="https://opencollective.com/uvdesk/contribute/sponsor-7372/checkout" target="_blank"><img src="https://images.opencollective.com/static/images/become_sponsor.svg"></a>

[1]: https://www.uvdesk.com/
[2]: https://github.com/uvdesk/core-framework
[3]: https://github.com/uvdesk/extension-framework
[4]: https://github.com/uvdesk/automation-bundle
[5]: https://github.com/uvdesk/support-center-bundle
[6]: https://support.uvdesk.com/en/blog/prerequisites-ubuntu
[7]: https://support.uvdesk.com/en/blog/prerequisites-ubuntu
[8]: https://getcomposer.org/
[9]: https://webkul.com/
[10]: https://www.uvdesk.com/en/team/
[11]: https://github.com/uvdesk/mailbox-component
[12]: https://github.com/uvdesk/community-skeleton/blob/master/LICENSE.txt
[13]: https://opencollective.com/uvdesk
[14]: https://docs.uvdesk.com/
[15]: https://demo.uvdesk.com/
[16]: https://github.com/uvdesk/api-bundle
[17]: https://www.trustpilot.com/review/uvdesk.com
[18]: https://www.capterra.com/p/158346/UVdesk/
[19]: https://www.softwaresuggest.com/uvdesk
[20]: https://gitter.im/uvdesk/community
[21]: https://forums.uvdesk.com/
[22]: https://github.com/uvdesk/community-skeleton/wiki/dockerize-helpdesk-project
[23]: https://support.uvdesk.com/en/blog/prerequisites-windows
[24]: https://symfony.com/projects/uvdesk
[25]: https://github.com/uvdesk/api-bundle/wiki/Ticket-Related-APIs
[26]: https://store.webkul.com/UVdesk/UVdesk-Open-Source.html
[27]: https://support.uvdesk.com/en/blog/prerequisites-mac
[28]: https://support.uvdesk.com/en/blog/prerequisites-centos7
[29]: https://www.uvdesk.com/en/blog/uvdesk-agent-activity/
[30]: https://www.uvdesk.com/en/blog/uvdesk-marketing-announcement/
[31]: https://support.uvdesk.com/es/blog/uvdesk-what-is-kudos
[32]: https://www.uvdesk.com/en/blog/language-translation-in-uvdesk-open-source-helpdesk/
[33]: https://github.com/uvdesk/community-skeleton/wiki/Vagrant-Virtual-Machine-Environment
[34]: https://github.com/uvdesk/community-skeleton/wiki/Docker-Persistent-Container
[35]: https://www.uvdesk.com/en/blog/marketing-module/
[36]: https://www.uvdesk.com/en/how-to-integrate-microsoft-app-to-your-opensource-uvdesk/

